use "Processed files\Pew.dta", clear

* Create macro data
xi: oprobit sat i.country [pw=wt]
predict sathat if sat~=., xb
tomode sathat, by(cty) replace
egen tag=tag(cty)
summ sathat if tag==1
replace sathat=sathat-r(mean)

* Table 1
* Micro
oprobit sat lgdp [pw=wt], robust cluster(cty) 
for X in num 1/4: gen ageX=age^X \ gen fageX=ageX*(sex==1)
global controls "age1-age4 fage1-fage4 sex sex_missing age_missing"
oprobit sat lgdp age1-age4 fage1-fage4 sex sex_missing age_missing [pw=wt], robust cluster(cty)
* Macro
reg sathat lgdp if tag==1, robust
reg sathat lgdp if tag==1 & gdp>15000, robust
reg sathat lgdp if tag==1 & gdp<15000, robust
gen rich=gdp>=15000 if gdp~=.
gen richXlgdp=rich*lgdp
reg sathat lgdp richXlgdp rich if tag==1, robust

* Table 2: Within-country estimates
xi: oprobit sat lninc i.cty [pw=wt], robust
xi: oprobit sat lninc $controls i.cty [pw=wt], robust
set matsize 2000
xi: reg lninc i.educ $controls i.cty [pw=wt] if sat~=., robust
predict lninc_hat2 if lninc~=. & sat~=.
predict lninc_res2 if lninc~=. & sat~=., res
xi: oprobit sat lninc_hat2 lninc_res2 $controls i.cty [pw=wt], robust


* Figures
cap program drop labgraph
program define labgraph
	syntax varlist [if]
	marksample touse
	correl `1' `2' `if'
	global rho=string(r(rho),"%4.3f")
	reg `1' `2' `if', robust
	global b=string(_b[`2'],"%3.2f")
	global a=string(_b[_cons],"%3.2f")
	global se=string(_se[`2'],"%3.2f")
end

reg sathat lgdp if tag==1, robust
predict sathathat if tag==1
lowess sathat lgdp if tag==1, nograph generate(sathat_low)
labgraph sathat lgdp if tag==1

#delimit ;
twoway
	(scatter sathat gdp, mlabel(cty) mlabpos(12) mcolor(navy) mlabcolor(navy))
	(line sathathat gdp, sort lpattern(longdash) lcolor(black))
	(line sathat_low gdp, sort lpattern(dot) lcolor(cranberry))
	if tag==1
,
	xscale(log)
	xlabel(500 ".5" 1000 "1" 2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32")
	ytitle("Life satisfaction (ordered probit index)", size(small))
	xtitle("Real GDP per capita (thousands of dollars, log scale)", size(small))
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%4.1f))
	legend(off)
	note("y = $a+$b*ln(x) [se=$se]" "Correlation=$rho", ring(0) pos(5))
	xsize(10) ysize(7.5)
	name(satgdp, replace)
;
#delimit cr
graph save "Figures\fig3.gph", replace

